<?php
/**
 *  iCagenda Event List
 *----------------------------------------------------------------------------
 * @package     mod_ic_event_list
 * @copyright   Copyright (c)2012-2018 Cyril Rezé, Jooml!C - All rights reserved

 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 * @author      Cyril Rezé (Lyr!C)
 * @link        http://www.joomlic.com
 *
 * @udpate      iCagenda 3.6.3
 * @version     3.12.0 2016-09-03
 * @since       1.0
 *----------------------------------------------------------------------------
*/

// no direct access
defined('_JEXEC') or die;

JModelLegacy::addIncludePath(JPATH_SITE . '/components/com_icagenda/models', 'iCagendaModel');

/**
 * Helper for mod_ic_event_list
 *
 * @package     iCagenda
 * @subpackage  mod_ic_event_list
 * @since       1.0
 */
abstract class modiCEventListHelper
{
	/**
	 * Retrieves the list of events
	 *
	 * @param array $params An object containing the module parameters
	 * @access public
	 */
	public static function getList(&$params)
	{
		// Get the dbo
		$db = JFactory::getDbo();

		// Get an instance of the generic events model
		$model = JModelLegacy::getInstance('Events', 'iCagendaModel', array('ignore_request' => true));

		// Set application parameters in model
		$app       = JFactory::getApplication();
		$appParams = $app->getParams();
		$model->setState('params', $appParams);

		// Set the filters based on the module params
		$model->setState('filter.state', 1);

//		$model->setState('list.select', 'e.*');

		// DateTime (Upcoming) filter
		$filter_by_date = $params->get('filter_by_date');

		if (isset($filter_by_date))
		{
			$upcoming = $params->get('filter_by_date', '1');
		}
		else
		{
			$upcoming = $params->get('time', '1'); // old setting (removed since 3.4.0-rc)

			if ($upcoming == '4') $upcoming = '5'; // convert old 'All' setting
			if ($upcoming == '3') $upcoming = '4'; // convert old 'today' setting
			if ($upcoming == '2') $upcoming = '3'; // convert old 'future' setting
			if ($upcoming == '0') $upcoming = '2'; // convert old 'past' setting
		}

		$model->setState('filter.upcoming', (int) $upcoming);

		// Set state for module params (Filter by features...)
		$model->setState('filter.mod_params', $params);

		// Display all dates filter
		$model->setState('filter.all_dates', $params->get('datesDisplay', '2'));

		// Category filter
		$model->setState('filter.category_id', $params->get('mcatid', 'all'));

		// Access filter
		$model->setState('filter.access', 'e.access');
		//$access = !JComponentHelper::getParams('com_icagenda')->get('show_noauth');
		//$authorised = JAccess::getAuthorisedViewLevels(JFactory::getUser()->get('id'));
		//$model->setState('filter.access', $access);

		// Filter by language
		$model->setState('filter.language', JLanguageMultilang::isEnabled());
//		$model->setState('filter.language',$app->getLanguageFilter());

		// Set number of events (processed in mod_ic_event_list.php)
//		$model->setState('list.start', 0);
//		$model->setState('list.limit', (int) $params->get('count', 5));

		// Set ordering
		$model->setState('list.ordering', 'e.next');

		// Set direction
		$orderby = $params->get('orderby');

		if (($orderby == '2')
			|| ($orderby == NULL))
		{
			$model->setState('list.direction', 'ASC');
		}
		else
		{
			$model->setState('list.direction', 'DESC');
		}

		// Retrieve Content
		$items = $model->getItems();

		return $items;
	}


	// Function to convert font color, depending on category color
	public static function getfontColor($cat_color)
	{
		$color = isset($cat_color) ? $cat_color : '';

		$hex_R = substr($color, 1, 2);
		$hex_G = substr($color, 3, 2);
		$hex_B = substr($color, 5, 2);
		$RGBhex = hexdec($hex_R).", ".hexdec($hex_G).", ".hexdec($hex_B);

		$RGB = explode(",", $RGBhex);
		$RGBa = $RGB[0];
		$RGBb = $RGB[1];
		$RGBc = $RGB[2];

		$somme = ($RGBa + $RGBb + $RGBc);

		if ($somme > '600')
		{
			$fcolor = '#111111';
		}
		else
		{
			$fcolor = 'white';
		}

		return $fcolor;
	}

	/**
	 * Get Thumbnail
	 *
	 * @since 3.0
	 */
	public static function getThumbnail($image, $thumb_generator)
	{
		// START iCthumb

		// Set if run iCthumb
		if ($image && ($thumb_generator == 1))
		{
			// Generate xsmall thumb if not exist
			$thumb_img = icagendaThumb::sizeXSmall($image);
		}
		elseif ($image && ($thumb_generator == 0))
		{
			$thumb_img = $image;
		}
		else
		{
			return false;
		}

		$baseURL = JURI::base();
		$thumb_img = ltrim($thumb_img, '/');

		return $baseURL . $thumb_img;
	}
}
