/*!
 * # Semantic UI 2.2.11 - Modal
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,i,n,t){"use strict";i=void 0!==i&&i.Math==Math?i:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")(),e.fn.modal=function(t){var o,r=e(this),a=e(i),s=e(n),c=e("body"),d=r.selector||"",l=(new Date).getTime(),u=[],m=arguments[0],f="string"==typeof m,g=[].slice.call(arguments,1),h=i.requestAnimationFrame||i.mozRequestAnimationFrame||i.webkitRequestAnimationFrame||i.msRequestAnimationFrame||function(e){setTimeout(e,0)};return r.each(function(){var r,v,b,p,y,k,w,S,C,M=e.isPlainObject(t)?e.extend(!0,{},e.fn.modal.settings,t):e.extend({},e.fn.modal.settings),F=M.selector,A=M.className,D=M.namespace,H=M.error,T="."+D,x="module-"+D,z=e(this),O=e(M.context),q=z.find(F.close),E=this,j=z.data(x),N=!1;C={initialize:function(){C.verbose("Initializing dimmer",O),C.create.id(),C.create.dimmer(),C.refreshModals(),C.bind.events(),M.observeChanges&&C.observeChanges(),C.instantiate()},instantiate:function(){C.verbose("Storing instance of modal"),j=C,z.data(x,j)},create:{dimmer:function(){var i={debug:M.debug,dimmerName:"modals"},n=e.extend(!0,i,M.dimmerSettings);if(void 0===e.fn.dimmer)return void C.error(H.dimmer);C.debug("Creating dimmer"),p=O.dimmer(n),M.detachable?(C.verbose("Modal is detachable, moving content into dimmer"),p.dimmer("add content",z)):C.set.undetached(),y=p.dimmer("get dimmer")},id:function(){w=(Math.random().toString(16)+"000000000").substr(2,8),k="."+w,C.verbose("Creating unique id for element",w)}},destroy:function(){C.verbose("Destroying previous modal"),z.removeData(x).off(T),a.off(k),y.off(k),q.off(T),O.dimmer("destroy")},observeChanges:function(){"MutationObserver"in i&&(S=new MutationObserver(function(e){C.debug("DOM tree modified, refreshing"),C.refresh()}),S.observe(E,{childList:!0,subtree:!0}),C.debug("Setting up mutation observer",S))},refresh:function(){C.remove.scrolling(),C.cacheSizes(),C.set.screenHeight(),C.set.type(),C.set.position()},refreshModals:function(){v=z.siblings(F.modal),r=v.add(z)},attachEvents:function(i,n){var t=e(i);n=e.isFunction(C[n])?C[n]:C.toggle,t.length>0?(C.debug("Attaching modal events to element",i,n),t.off(T).on("click"+T,n)):C.error(H.notFound,i)},bind:{events:function(){C.verbose("Attaching events"),z.on("click"+T,F.close,C.event.close).on("click"+T,F.approve,C.event.approve).on("click"+T,F.deny,C.event.deny),a.on("resize"+k,C.event.resize)}},get:{id:function(){return(Math.random().toString(16)+"000000000").substr(2,8)}},event:{approve:function(){if(N||!1===M.onApprove.call(E,e(this)))return void C.verbose("Approve callback returned false cancelling hide");N=!0,C.hide(function(){N=!1})},deny:function(){if(N||!1===M.onDeny.call(E,e(this)))return void C.verbose("Deny callback returned false cancelling hide");N=!0,C.hide(function(){N=!1})},close:function(){C.hide()},click:function(i){var t=e(i.target),o=t.closest(F.modal).length>0,r=e.contains(n.documentElement,i.target);!o&&r&&(C.debug("Dimmer clicked, hiding all modals"),C.is.active()&&(C.remove.clickaway(),M.allowMultiple?C.hide():C.hideAll()))},debounce:function(e,i){clearTimeout(C.timer),C.timer=setTimeout(e,i)},keyboard:function(e){27==e.which&&(M.closable?(C.debug("Escape key pressed hiding modal"),C.hide()):C.debug("Escape key pressed, but closable is set to false"),e.preventDefault())},resize:function(){p.dimmer("is active")&&(C.is.animating()||C.is.active())&&h(C.refresh)}},toggle:function(){C.is.active()||C.is.animating()?C.hide():C.show()},show:function(i){i=e.isFunction(i)?i:function(){},C.refreshModals(),C.set.dimmerSettings(),C.showModal(i)},hide:function(i){i=e.isFunction(i)?i:function(){},C.refreshModals(),C.hideModal(i)},showModal:function(i){i=e.isFunction(i)?i:function(){},C.is.animating()||!C.is.active()?(C.showDimmer(),C.cacheSizes(),C.set.position(),C.set.screenHeight(),C.set.type(),C.set.clickaway(),!M.allowMultiple&&C.others.active()?C.hideOthers(C.showModal):(M.onShow.call(E),M.transition&&void 0!==e.fn.transition&&z.transition("is supported")?(C.debug("Showing modal with css animations"),z.transition({debug:M.debug,animation:M.transition+" in",queue:M.queue,duration:M.duration,useFailSafe:!0,onComplete:function(){M.onVisible.apply(E),M.keyboardShortcuts&&C.add.keyboardShortcuts(),C.save.focus(),C.set.active(),M.autofocus&&C.set.autofocus(),i()}})):C.error(H.noTransition))):C.debug("Modal is already visible")},hideModal:function(i,n){if(i=e.isFunction(i)?i:function(){},C.debug("Hiding modal"),!1===M.onHide.call(E,e(this)))return void C.verbose("Hide callback returned false cancelling hide");(C.is.animating()||C.is.active())&&(M.transition&&void 0!==e.fn.transition&&z.transition("is supported")?(C.remove.active(),z.transition({debug:M.debug,animation:M.transition+" out",queue:M.queue,duration:M.duration,useFailSafe:!0,onStart:function(){C.others.active()||n||C.hideDimmer(),M.keyboardShortcuts&&C.remove.keyboardShortcuts()},onComplete:function(){M.onHidden.call(E),C.restore.focus(),i()}})):C.error(H.noTransition))},showDimmer:function(){p.dimmer("is animating")||!p.dimmer("is active")?(C.debug("Showing dimmer"),p.dimmer("show")):C.debug("Dimmer already visible")},hideDimmer:function(){if(!p.dimmer("is animating")&&!p.dimmer("is active"))return void C.debug("Dimmer is not visible cannot hide");p.dimmer("hide",function(){C.remove.clickaway(),C.remove.screenHeight()})},hideAll:function(i){var n=r.filter("."+A.active+", ."+A.animating);i=e.isFunction(i)?i:function(){},n.length>0&&(C.debug("Hiding all visible modals"),C.hideDimmer(),n.modal("hide modal",i))},hideOthers:function(i){var n=v.filter("."+A.active+", ."+A.animating);i=e.isFunction(i)?i:function(){},n.length>0&&(C.debug("Hiding other modals",v),n.modal("hide modal",i,!0))},others:{active:function(){return v.filter("."+A.active).length>0},animating:function(){return v.filter("."+A.animating).length>0}},add:{keyboardShortcuts:function(){C.verbose("Adding keyboard shortcuts"),s.on("keyup"+T,C.event.keyboard)}},save:{focus:function(){b=e(n.activeElement).blur()}},restore:{focus:function(){b&&b.length>0&&b.focus()}},remove:{active:function(){z.removeClass(A.active)},clickaway:function(){M.closable&&y.off("click"+k)},bodyStyle:function(){""===c.attr("style")&&(C.verbose("Removing style attribute"),c.removeAttr("style"))},screenHeight:function(){C.debug("Removing page height"),c.css("height","")},keyboardShortcuts:function(){C.verbose("Removing keyboard shortcuts"),s.off("keyup"+T)},scrolling:function(){p.removeClass(A.scrolling),z.removeClass(A.scrolling)}},cacheSizes:function(){var t=z.outerHeight();void 0!==C.cache&&0===t||(C.cache={pageHeight:e(n).outerHeight(),height:t+M.offset,contextHeight:"body"==M.context?e(i).height():p.height()}),C.debug("Caching modal and container sizes",C.cache)},can:{fit:function(){return C.cache.height+2*M.padding<C.cache.contextHeight}},is:{active:function(){return z.hasClass(A.active)},animating:function(){return z.transition("is supported")?z.transition("is animating"):z.is(":visible")},scrolling:function(){return p.hasClass(A.scrolling)},modernBrowser:function(){return!(i.ActiveXObject||"ActiveXObject"in i)}},set:{autofocus:function(){var e=z.find("[tabindex], :input").filter(":visible"),i=e.filter("[autofocus]"),n=i.length>0?i.first():e.first();n.length>0&&n.focus()},clickaway:function(){M.closable&&y.on("click"+k,C.event.click)},dimmerSettings:function(){if(void 0===e.fn.dimmer)return void C.error(H.dimmer);var i={debug:M.debug,dimmerName:"modals",variation:!1,closable:"auto",duration:{show:M.duration,hide:M.duration}},n=e.extend(!0,i,M.dimmerSettings);M.inverted?(n.variation=void 0!==n.variation?n.variation+" inverted":"inverted",y.addClass(A.inverted)):y.removeClass(A.inverted),M.blurring?p.addClass(A.blurring):p.removeClass(A.blurring),O.dimmer("setting",n)},screenHeight:function(){C.can.fit()?c.css("height",""):(C.debug("Modal is taller than page content, resizing page height"),c.css("height",C.cache.height+2*M.padding))},active:function(){z.addClass(A.active)},scrolling:function(){p.addClass(A.scrolling),z.addClass(A.scrolling)},type:function(){C.can.fit()?(C.verbose("Modal fits on screen"),C.others.active()||C.others.animating()||C.remove.scrolling()):(C.verbose("Modal cannot fit on screen setting to scrolling"),C.set.scrolling())},position:function(){C.verbose("Centering modal on page",C.cache),C.can.fit()?z.css({top:"",marginTop:-C.cache.height/2}):z.css({marginTop:"",top:s.scrollTop()})},undetached:function(){p.addClass(A.undetached)}},setting:function(i,n){if(C.debug("Changing setting",i,n),e.isPlainObject(i))e.extend(!0,M,i);else{if(void 0===n)return M[i];e.isPlainObject(M[i])?e.extend(!0,M[i],n):M[i]=n}},internal:function(i,n){if(e.isPlainObject(i))e.extend(!0,C,i);else{if(void 0===n)return C[i];C[i]=n}},debug:function(){!M.silent&&M.debug&&(M.performance?C.performance.log(arguments):(C.debug=Function.prototype.bind.call(console.info,console,M.name+":"),C.debug.apply(console,arguments)))},verbose:function(){!M.silent&&M.verbose&&M.debug&&(M.performance?C.performance.log(arguments):(C.verbose=Function.prototype.bind.call(console.info,console,M.name+":"),C.verbose.apply(console,arguments)))},error:function(){M.silent||(C.error=Function.prototype.bind.call(console.error,console,M.name+":"),C.error.apply(console,arguments))},performance:{log:function(e){var i,n,t;M.performance&&(i=(new Date).getTime(),t=l||i,n=i-t,l=i,u.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:E,"Execution Time":n})),clearTimeout(C.performance.timer),C.performance.timer=setTimeout(C.performance.display,500)},display:function(){var i=M.name+":",n=0;l=!1,clearTimeout(C.performance.timer),e.each(u,function(e,i){n+=i["Execution Time"]}),i+=" "+n+"ms",d&&(i+=" '"+d+"'"),(void 0!==console.group||void 0!==console.table)&&u.length>0&&(console.groupCollapsed(i),console.table?console.table(u):e.each(u,function(e,i){console.log(i.Name+": "+i["Execution Time"]+"ms")}),console.groupEnd()),u=[]}},invoke:function(i,n,t){var r,a,s,c=j;return n=n||g,t=E||t,"string"==typeof i&&void 0!==c&&(i=i.split(/[\. ]/),r=i.length-1,e.each(i,function(n,t){var o=n!=r?t+i[n+1].charAt(0).toUpperCase()+i[n+1].slice(1):i;if(e.isPlainObject(c[o])&&n!=r)c=c[o];else{if(void 0!==c[o])return a=c[o],!1;if(!e.isPlainObject(c[t])||n==r)return void 0!==c[t]&&(a=c[t],!1);c=c[t]}})),e.isFunction(a)?s=a.apply(t,n):void 0!==a&&(s=a),e.isArray(o)?o.push(s):void 0!==o?o=[o,s]:void 0!==s&&(o=s),a}},f?(void 0===j&&C.initialize(),C.invoke(m)):(void 0!==j&&j.invoke("destroy"),C.initialize())}),void 0!==o?o:this},e.fn.modal.settings={name:"Modal",namespace:"modal",silent:!1,debug:!1,verbose:!1,performance:!0,observeChanges:!1,allowMultiple:!1,detachable:!0,closable:!0,autofocus:!0,inverted:!1,blurring:!1,dimmerSettings:{closable:!1,useCSS:!0},keyboardShortcuts:!0,context:"body",queue:!1,duration:500,offset:0,transition:"scale",padding:50,onShow:function(){},onVisible:function(){},onHide:function(){return!0},onHidden:function(){},onApprove:function(){return!0},onDeny:function(){return!0},selector:{close:"> .close",approve:".actions .positive, .actions .approve, .actions .ok",deny:".actions .negative, .actions .deny, .actions .cancel",modal:".ui.modal"},error:{dimmer:"UI Dimmer, a required component is not included in this page",method:"The method you called is not defined.",notFound:"The element you specified could not be found"},className:{active:"active",animating:"animating",blurring:"blurring",inverted:"inverted",scrolling:"scrolling",undetached:"undetached"}}}(jQuery,window,document);