<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *----------------------------------------------------------------------------
 * @version     3.7.2 2018-06-08
 *
 * @package     iCagenda.Site
 * @link        https://icagenda.joomlic.com
 *
 * @author      Cyril Rezé
 * @copyright   (c) 2012-2018 Jooml!C / Cyril Rezé. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 * @since       3.6.0
 *----------------------------------------------------------------------------
*/

defined('_JEXEC') or die;

JHtml::_('behavior.keepalive');

if (version_compare(JVERSION, '3.3.6', 'le'))
{
	// For versions from 2.5 to 3.3.6
	JHtml::_('behavior.formvalidation');
}
else
{
	// For versions from 3.4
	JHtml::_('behavior.formvalidator');
}

// Get the core Joomla objects
$app			= JFactory::getApplication();
$document		= JFactory::getDocument();

// Shortcut for item
$item			= $this->item;

// Form Validation (Only Server side validation (1), or Client & Server validation (default))
$form_validate	= ($this->reg_form_validation == 1) ? '' : ' form-validate';
$novalidate		= ($this->reg_form_validation == 1) ? ' novalidate' : '';

// Load custom fields
$customFields	= icagendaCustomfields::getCustomFields(1, $item->params->get('custom_form', ''));
$listSlugs		= icagendaCustomfields::listSlugs($customFields);

// Terms
$terms			= $this->params->get('terms', 0);
$session		= JFactory::getSession();
$ic_submit_tos	= $session->get('ic_submit_tos', '');
?>

<div id="icagenda" class="ic-registration-view<?php echo $this->pageclass_sfx; ?>">

	<?php echo "<!-- " . $this->template . " -->"; ?>

	<?php // iCagenda Vars ?>
	<?php require_once $this->icevent_vars; ?>

	<?php // Content is generated by content plugin event "iCagendaOnRegistrationBeforeDisplay" ?>
	<?php echo $item->event->iCagendaOnRegistrationBeforeDisplay; ?>

	<?php // Theme Pack layout (Header) ?>
	<?php require_once $this->themeRegistration; ?>

	<?php // START CONTENT ?>

	<?php // TITLE REGISTRATION ?>
	<div class="ic-form-title">
		<h1><?php echo JText::_('COM_ICAGENDA_REGISTRATION_TITLE'); ?></h1>
	</div>

	<?php // FIELDS REQUIRED INFO ?>
	<div class="ic-required-info">
		<?php echo JText::_('COM_ICAGENDA_FORM_REQUIRED_INFO'); ?>
	</div>

	<?php // START FORM ?>
	<form class="<?php echo $form_validate; ?> form-horizontal well"
		id="icagenda-registration"
		action="<?php echo JRoute::_('index.php?option=com_icagenda&task=registration.register'); ?>"
		method="post"
		enctype="multipart/form-data"<?php echo $novalidate; ?>
		>

		<legend><?php echo JText::_('COM_ICAGENDA_REGISTRATION_YOUR_INFORMATION_LEGEND'); ?></legend>

		<fieldset>

		<?php // CORE FIELDS (fieldset 'default') ?>
		<?php $fields = $this->form->getFieldset('default'); ?>
		<?php if (count($fields)) : ?>
			<?php // Iterate through the fields in the set and display them. ?>
			<?php foreach ($fields as $field) : ?>
				<?php $name = str_replace(array('[', ']', 'jform'), '', $field->name); ?>
				<?php // If display this core field, and not overrided in custom fields. ?>
				<?php if (isset($this->coreFields[$name]) && $this->coreFields[$name] && ! in_array('core_' . $name, $listSlugs)) : ?>
					<?php // If field date OR field is readonly, no infotip and label tooltip. ?>
					<?php if (($name == 'date') || $field->readonly) : ?>
						<?php $infoTip = ''; ?>
						<?php //if (version_compare(JVERSION, '3.0', 'ge')) $field->description = ''; ?>
						<?php $this->form->setFieldAttribute($name, 'description', ''); ?>
					<?php // Set the infotip and remove label tooltip. ?>
					<?php elseif ($field->description) : ?>
						<?php $infoTip = '<span class="iCFormTip iCicon iCicon-info-circle" title="'; ?>
						<?php $infoTip.= htmlspecialchars('<strong>' . JText::_($field->title) . '</strong><br />' . JText::_($field->description)); ?>
						<?php $infoTip.= '"></span>'; ?>
						<?php $this->form->setFieldAttribute($name, 'description', ''); ?>
					<?php else : ?>
						<?php $infoTip = ''; ?>
					<?php endif; ?>
					<?php // If the field is hidden or only one ticket per registration, just display the hidden input. ?>
					<?php if ($field->hidden || ($name == 'people' && $item->tickets == 1)) : ?>
						<?php echo $this->form->getInput($name); ?>
					<?php else : ?>
						<div class="control-group">
							<div class="control-label">
								<?php echo $this->form->getLabel($name); ?>
							</div>
							<div class="controls">
								<?php echo $this->form->getInput($name); ?>
								<?php echo $infoTip; ?>
							</div>
						</div>
					<?php endif; ?>
				<?php endif; ?>
			<?php endforeach; ?>
		<?php endif; ?>


		<?php // CUSTOM FIELDS ?>
		<?php if ($customFields && count($customFields)) : ?>
			<?php // Load Custom fields - Registration form (1); ?>
			<?php icagendaCustomfields::loader(1, $item->params->get('custom_form', ''), $customFields); ?>
			<?php // Iterate through the fields in the set and display them. ?>
			<?php foreach ($customFields as $field) : ?>
				<?php $infoTip = ''; ?>
				<?php if ($field->description) : ?>
					<?php $infoTip.= '<span class="iCFormTip iCicon iCicon-info-circle" title="'; ?>
					<?php $infoTip.= htmlspecialchars('<strong>' . JText::_($field->title) . '</strong><br />' . JText::_($field->description)); ?>
					<?php $infoTip.= '"></span>'; ?>
					<?php $this->form->setFieldAttribute($field->slug, 'description', ''); ?>
				<?php endif; ?>
				<?php // If the field is hidden, just display the input. ?>
				<?php if ($field->type == 'hidden') : ?>
					<?php echo $this->form->getInput($field->slug); ?>
				<?php else : ?>
					<div class="control-group">
						<div class="control-label">
							<?php echo $this->form->getLabel($field->slug); ?>
						</div>
						<div class="controls">
							<?php echo $this->form->getInput($field->slug); ?>
							<?php echo $infoTip; ?>
						</div>
					</div>
					<?php // If Override Email, add the email2 field (if enabled in global options). ?>
					<?php if ($field->slug == 'email' && $this->params->get('emailConfirm', 1)) : ?>
						<div class="control-group">
							<div class="control-label">
								<?php echo $this->form->getLabel('email2'); ?>
							</div>
							<div class="controls">
								<?php echo $this->form->getInput('email2'); ?>
								<?php echo $infoTip; ?>
							</div>
						</div>
					<?php endif; ?>
				<?php endif; ?>
			<?php endforeach; ?>
		<?php endif; ?>


		<?php // Temporary FIELDS (fieldset 'temporary', to be migrated soon to core/override) ?>
		<?php $fields = $this->form->getFieldset('temporary'); ?>
		<?php if (count($fields)) : ?>
			<?php // Iterate through the fields in the set and display them. ?>
			<?php foreach ($fields as $field) : ?>
				<?php $name = str_replace(array('[', ']', 'jform'), '', $field->name); ?>
				<?php if (isset($this->extraFields[$name]) && $this->extraFields[$name]) : ?>
					<?php // If the field is hidden, just display the input. ?>
					<?php if ($field->hidden) : ?>
						<?php echo $this->form->getInput($name); ?>
					<?php else : ?>
						<?php echo $field->renderField(); ?>
					<?php endif; ?>
				<?php endif; ?>
			<?php endforeach; ?>
		<?php endif; ?>

		</fieldset>


		<?php // PRIVACY ?>
		<?php $name_visibility      = $this->params->get('participant_name_visibility', ''); ?>
		<?php $name_consent         = $this->params->get('participant_name_consent', ''); // '0' means Force Name Consent (no consent request in form) ?>
		<?php $gravatar_consent     = $this->params->get('participant_gravatar_consent', ''); ?>
		<?php $gravatar_checkbox    = ($this->params->get('participantDisplay') != '3' || $gravatar_consent == '1')
									? $gravatar_consent
									: '0'; ?>

		<?php if (($this->params->get('participantList', 0) && (($name_visibility && $name_consent != '0') || $gravatar_checkbox != '0'))
					|| $this->params->get('privacy_organiser', 0)
					|| ($name_visibility && $name_consent == '1')
					|| $gravatar_checkbox == '1'): ?>
			<legend><?php echo JText::_('COM_ICAGENDA_REGISTRATION_CONSENT_PERSONAL_DATA_LEGEND'); ?></legend>

			<fieldset>

				<?php // Privacy: Participant name ?>
				<?php if ($name_visibility && $name_consent != '0') : ?>
					<?php $consent_access = ($name_visibility == 1) ? '_public' : '_users'; ?>
					<?php echo $this->form->renderField('consent_name' . $consent_access, 'consent'); ?>
				<?php endif; ?>

				<?php // Privacy: Gravatar ?>
				<?php if ($gravatar_checkbox == '1' || ($gravatar_checkbox == '' && $this->params->get('participantList', 0))) : ?>
					<?php echo $this->form->renderField('consent_gravatar', 'consent'); ?>
				<?php endif; ?>

				<?php // Privacy: Sharing information with Event Organiser ?>
				<?php if ($this->params->get('privacy_organiser', 0)) : ?>
					<?php echo $this->form->renderField('consent_organiser', 'consent'); ?>
				<?php endif; ?>

			</fieldset>
		<?php endif; ?>


		<?php // Terms & Conditions ?>
		<?php if ($this->params->get('terms', 1)) : ?>
			<?php echo $this->form->renderField('consent_terms', 'consent'); ?>
		<?php endif; ?>


		<?php // EXTRA FIELDS (fieldset 'extra', not enabled by default) ?>
		<?php $fields = $this->form->getFieldset('extra'); ?>
		<?php if (count($fields)) : ?>
			<fieldset>
			<?php // Iterate through the fields in the set and display them. ?>
			<?php foreach ($fields as $field) : ?>
				<?php $name = str_replace(array('[', ']', 'jform'), '', $field->name); ?>
				<?php if (isset($this->extraFields[$name]) && $this->extraFields[$name]) : ?>
					<?php // If the field is hidden, just display the input. ?>
					<?php if ($field->hidden) : ?>
						<?php echo $this->form->getInput($name); ?>
					<?php else : ?>
						<?php echo $field->renderField(); ?>
					<?php endif; ?>
				<?php endif; ?>
			<?php endforeach; ?>
			</fieldset>
		<?php endif; ?>


		<?php // HIDDEN FIELDS (fieldset 'hidden') ?>
		<?php $eventid = $app->input->getInt('id'); ?>
		<?php $menuid  = $app->input->getInt('Itemid'); ?>
		<?php $fields  = $this->form->getFieldset('hidden'); ?>
		<?php if (count($fields)) : ?>
			<fieldset>
			<?php // Iterate through the fields in the set and display them. ?>
			<?php foreach ($fields as $field) : ?>
				<?php $name = str_replace(array('[', ']', 'jform'), '', $field->name); ?>
				<?php if ($field->hidden) : ?>
					<?php echo $this->form->getInput($name, null, ${$name}); ?>
				<?php endif; ?>
			<?php endforeach; ?>
			</fieldset>
		<?php endif; ?>

		<?php // Input to process registration function, not saved in database ?>
		<input name="jform[type_registration]" type="hidden" value="<?php echo $item->params->get('typeReg', '1'); ?>" />
		<input name="jform[current_url]" type="hidden" value="<?php echo JUri::getInstance()->toString(); ?>" />
		<input name="jform[max_nb_of_tickets]" type="hidden" value="<?php echo $item->params->get('maxReg', '1000000'); ?>" />

<?php
if ($this->actions
	&& $item->params->get('registration_actions', 0))
{
	$registerButton = JText::_('JNEXT');
}
else
{
	$registerButton = JText::_('COM_ICAGENDA_REGISTRATION_REGISTER_BTN');
	$registerButton = 'Register' ? JText::_('JREGISTER') : $registerButton; // B/C before 3.6.13
}
?>

		<?php // Form Submit or Cancel ?>
		<div class="control-group" id="submit">
			<div class="controls">
				<button class="btn btn-primary validate" type="submit"><?php echo $registerButton; ?></button>
				<input name="eventID" type="hidden" value="<?php echo $eventid; ?>" />
				<input name="option" type="hidden" value="com_icagenda" />
				<input name="task" type="hidden" value="registration.register" />
				<?php echo JHtml::_('form.token'); ?>
				<a class="btn" href="<?php echo icagendaEvent::url($item->id, $item->alias); ?>" title="<?php echo JTEXT::_('COM_ICAGENDA_CANCEL'); ?>">
					<?php echo JTEXT::_('COM_ICAGENDA_CANCEL'); ?>
				</a>
			</div>
		</div>
	</form>

	<?php // Content is generated by content plugin event "iCagendaOnRegistrationAfterDisplay" ?>
	<?php echo $item->event->iCagendaOnRegistrationAfterDisplay; ?>
</div>

<?php
// Add iCtip declaration
$document->addScriptDeclaration('
	jQuery(document).ready(function(){
		jQuery(".iCFormTip").tipTip({maxWidth: "250px", defaultPosition: "right", edgeOffset: 10});
	});
');

// Disable submit button after first click (TODO : check and simplify)
$document->addScriptDeclaration('
	jQuery(function($) {
		$("#icagenda-registration").one("submit", function() {
			$(this).find(\'button[type="submit"]\')
				.attr("disabled","disabled")
				.css({
					"background-color": "transparent",
					"color": "grey"
				});
			$("#submit").addClass("ic-loader");
			$(".buttonx").css("display", "none");
		});
	});
');
