<?php
defined('JPATH_BASE') or die;
jimport( 'joomla.html.parameter' );

include_once('pesapal-iframe.php');

class pesapalCheckStatus {

	var $consumer_key;
	var $consumer_secret;
	var $signature_method;

	public function __construct(){

		// PHPMailer has an issue using the relative path for it's language files

		$pesapal=new JPesapal();
		//$this->token = $this->params = NULL;
		$this->consumer_key = $pesapal->consumer_key;
		$this->consumer_secret = $pesapal->consumer_secret;
		$this->signature_method = new OAuthSignatureMethod_HMAC_SHA1();
	}

	function checkStatus($transaction_id,$reference){
		$component = JComponentHelper::getComponent( 'com_donation' );
 		$params = new JParameter( $component->params );
		
		$statusrequest	= $params->get ( 'link_prefix' ).'.pesapal.com/API/querypaymentstatus';
		
		$token = $params = NULL;
		$consumer = new OAuthConsumer($this->consumer_key, $this->consumer_secret);
		
		//get transaction status
		$request_status = OAuthRequest::from_consumer_and_token($consumer, $token, "GET", $statusrequest, $params);
		$request_status->set_parameter("pesapal_merchant_reference", $reference);
        $request_status->set_parameter("pesapal_transaction_tracking_id", $transaction_id);
		$request_status->sign_request($this->signature_method, $consumer, $token);

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $request_status);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_HEADER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		if(defined('CURL_PROXY_REQUIRED')) if (CURL_PROXY_REQUIRED == 'True'){
			$proxy_tunnel_flag = (defined('CURL_PROXY_TUNNEL_FLAG') && strtoupper(CURL_PROXY_TUNNEL_FLAG) == 'FALSE') ? false : true;
			curl_setopt ($ch, CURLOPT_HTTPPROXYTUNNEL, $proxy_tunnel_flag);
			curl_setopt ($ch, CURLOPT_PROXYTYPE, CURLPROXY_HTTP);
			curl_setopt ($ch, CURLOPT_PROXY, CURL_PROXY_SERVER_DETAILS);
		}

		$response 					= curl_exec($ch);
		$header_size 				= curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$raw_header  				= substr($response, 0, $header_size - 4);
		$headerArray 				= explode("\r\n\r\n", $raw_header);
		$header 					= $headerArray[count($headerArray) - 1];

		//transaction status
		$elements = preg_split("/=/",substr($response, $header_size));
		$pesapal_response_data = $elements[1];
		
		return $pesapal_response_data;
	}



	function checkStatusWithMethod($tracking_id,$reference){
		$component = JComponentHelper::getComponent( 'com_donation' );
 		$params = new JParameter( $component->params );
		$statusrequest	= $params->get ( 'link_prefix' ).'.pesapal.com/API/querypaymentdetails';
		$token = $params = NULL;
		$consumer = new OAuthConsumer($this->consumer_key, $this->consumer_secret);
		$request_status = OAuthRequest::from_consumer_and_token($consumer, $token, "GET", $statusrequest, $params);
		$request_status->set_parameter("pesapal_merchant_reference", $reference);
		$request_status->set_parameter("pesapal_transaction_tracking_id",$tracking_id);
		$request_status->sign_request($this->signature_method, $consumer, $token);

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $request_status);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_HEADER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		if(defined('CURL_PROXY_REQUIRED')) if (CURL_PROXY_REQUIRED == 'True'){
			$proxy_tunnel_flag = (defined('CURL_PROXY_TUNNEL_FLAG') && strtoupper(CURL_PROXY_TUNNEL_FLAG) == 'FALSE') ? false : true;
			curl_setopt ($ch, CURLOPT_HTTPPROXYTUNNEL, $proxy_tunnel_flag);
			curl_setopt ($ch, CURLOPT_PROXYTYPE, CURLPROXY_HTTP);
			curl_setopt ($ch, CURLOPT_PROXY, CURL_PROXY_SERVER_DETAILS);
		}

		$response 					= curl_exec($ch);
		$header_size 				= curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$raw_header  				= substr($response, 0, $header_size - 4);
		$headerArray 				= explode("\r\n\r\n", $raw_header);
		$header 					= $headerArray[count($headerArray) - 1];

		//transaction status
		$elements = preg_split("/=/",substr($response, $header_size));
		$status = explode(",", $elements[1]);
		$statusArray=array('pesapal_transaction_tracking_id'=>$status[0],
				   'payment_method'=>$status[1],
				   'status'=>$status[2],
				   'pesapal_merchant_reference'=>$status[3]);		   

		return $statusArray;
	}

	function checkStatusWithOrder($order_id){
	
		$component = JComponentHelper::getComponent( 'com_donation' );
 		$params = new JParameter( $component->params );

		$statusrequest	=	$params->get ( 'link_prefix' ).'.pesapal.com/API/QueryPaymentStatusByMerchantRef';
		$consumer 		= 	new OAuthConsumer($this->consumer_key, $this->consumer_secret);

		//get transaction status
		$request_status = OAuthRequest::from_consumer_and_token($consumer, $token, "GET", $statusrequest, $params);
		$request_status->set_parameter("pesapal_merchant_reference", $order_id);
		$request_status->sign_request($this->signature_method, $consumer, $token);
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $request_status);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_HEADER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		if(defined('CURL_PROXY_REQUIRED')) if (CURL_PROXY_REQUIRED == 'True'){
			$proxy_tunnel_flag = (defined('CURL_PROXY_TUNNEL_FLAG') && strtoupper(CURL_PROXY_TUNNEL_FLAG) == 'FALSE') ? false : true;
			curl_setopt ($ch, CURLOPT_HTTPPROXYTUNNEL, $proxy_tunnel_flag);
			curl_setopt ($ch, CURLOPT_PROXYTYPE, CURLPROXY_HTTP);
			curl_setopt ($ch, CURLOPT_PROXY, CURL_PROXY_SERVER_DETAILS);
		}

		$response 					= curl_exec($ch);
		$header_size 				= curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$raw_header  				= substr($response, 0, $header_size - 4);
		$headerArray 				= explode("\r\n\r\n", $raw_header);
		$header 					= $headerArray[count($headerArray) - 1];

		//transaction status
		$elements = preg_split("/=/",substr($response, $header_size));
		
		$status = $elements[1];

		return $status;
	}
	
}

?>